/*********************************************************************************
DATA ARRAYS (XML DATA LOADED AS NEEDED FROM WITHIN EACH PAGE)
*********************************************************************************/


//MOTOR VALUES
//FIELDS   0          1        2   3       4       5       6      7      8            9          10           11          12           13
//Syntax:[ 'Company', 'Model' ,kv, kvType, maxRPM, motorR, power, poles, motorLength, motorDiam, motorWeight, flangeDiam, shaftLength, shaftDiam
//kv_type: 0=kv is "unloaded", 1=kv is "loaded", -1=unknown
var kv;


//DIFFERENTIAL GEAR RATIOS
//Syntax: [ 'Company','Model',outTeeth,inTeeth ]
var Differential;


//TRANSMISSION GEAR RATIOS
//Syntax: [ 'Company','Description',teeth1,teeth2,teeth3,teeth4 ]
//tooth count values vary. Can have: output, input | output, intermediate, input | output1, input1, output2, input2
var Transmission;


//SPUR GEARS
//Syntax: [ 'Company','Description','pitch',teeth ]
var Spur;


//TIRE SIZES ARRAY
//DATA ROW SYNTAX: [ 'COMPANY','MODEL','SCALE','TYPE',DIAMETER)	]
var Tires;


//DATA FOR BALANCER CONNECTOR DIAGRAM
//Syntax: [ 'image url' , 'balancer description' ]
var balConn=[
['bal_gen_2s2s_wmain.gif','High Amp 2s+2s generic connector'],
['bal_gen_3s2s_wmain.gif','High Amp 3s+2s generic connector'],
['bal_gen_3s3s_wmain.gif','High Amp 3s+3s generic connector'],
['bal_hyp_2s2s_wmain.gif','High Amp 2s+2s Hyperion connector'],
['bal_hyp_3s2s_wmain.gif','High Amp 3s+2s Hyperion connector'],
['bal_hyp_3s3s_wmain.gif','High Amp 3s+3s Hyperion connector'],
['trakpower_2s2s_wmain.gif','High Amp 2s+2s Trackpower'],
['bal_gen_2s2s_nomain.gif','Low Amp 2s+2s generic connector'],
['bal_gen_3s2s_nomain.gif','Low Amp 3s+2s generic connector'],
['bal_gen_3s3s_nomain.gif','Low Amp 3s+3s generic connector'],
['bal_hyp_2s2s_nomain.gif','Low Amp 2s+2s Hyperion connector'],
['bal_hyp_3s2s_nomain.gif','Low Amp 3s+2s Hyperion connector'],
['bal_hyp_3s3s_nomain.gif','Low Amp 3s+3s Hyperion connector'],
['trakpower_2s2s_nomain.gif','Low Amp 2s+2s Trackpower']
]



//LIST OF VARIOUS POSSIBLE CELL VOLTAGES
var voltagesT=['4.2v Lipo max','4.1v','4.0v','3.9v','3.8v','3.7v Lipo nom','3.6v LiFe max','3.5v','3.4v','3.3v LiFe nom','3.2v','3.1v','3.0v Lipo min','2.9v','2.8v LiFe min','1.4v NiMH max','1.3v','1.2v NiMH nom','1.1v','1.0v','0.9v','0.8v NiMH min'];
var voltagesV=[4.2, 4.1, 4.0, 3.9, 3.8, 3.7, 3.6, 3.5, 3.4, 3.3, 3.2, 3.1, 3.0, 2.9, 2.8, 1.4, 1.3, 1.2, 1.1, 1.0, 0.9, 0.8];

//MAX AMOUNT OF CELLS
var cellCount=30;


//GEAR PITCH TABLE
//Syntax: [ 'Pitch Description' , diametrical_pitch ]
var pitch=[
['Mod 1.5',	16.92	],
['Mod 1.0',	25.4	],
['32p',	32	],
['Mod 0.8',	31.75	],
['48p',	48 	],
['Mod 0.4',	63.5	]
]


//SCALE LIST
var scale=['36th','24th','18th','16th','12th','10th','8th','5th','4th'];


//VEHICLE TYPE LIST
var vehicleType=['Truck (general)','Monster Truck','Truggy','Buggy','Stadium Truck','Sedan','Short Course Truck'];


//SHOCK DIMENSION TABLE
//Syntax: ['Make/Model',	L(overall),	L(h-h),	Lmin(h-h),	Diam(overall),	Diam(bore), Diam(shaft)]
var shocks=[
['Losi LST2 Front or Rear',		165.00,		153.00,		104.00,		14.90,		24.85,		4.00],
['Losi Muggy Front or Rear',	165.00,		153.00,		104.00,		14.90,		24.85,		4.00],
['MGT MMT Front or Rear',		152.00,		143.00,		97.00,		19.50,		13.95,		2.95],
['Mugen MBX5r Rear',			140.00,		130.00,		90.00,		20.30,		15.00,		3.45],
['Ofna Jammin CRT.5 Front',		82.50,		73.62,		55.19,		16.50,		12.50,		2.94],
['Ofna Jammin CRT.5 Rear',		111.10,		102.22,		70.74,		16.50,		12.50,		2.94],
['Ofna Jammin X2 Front',		115.00,		105.00,		78.00,		24.35,		19.00,		3.50],
['Ofna Jammin X2 Rear',			134.00,		124.00,		88.00,		24.35,		19.00,		3.50],
['Traxxas Revo Front or Rear',	96.00,		85.50,		63.00,		22.25,		16.00,		3.50],
['Traxxas Jato Front or Rear',	96.00,		85.50,		63.00,		22.25,		16.00,		3.50],
['Xray 808 Front or Rear',		125.00,		115.00,		80.00,		24.00,		18.40,		3.45],
['XRay XT8 Front',				117.00,		107.00,		80.00,		20.30,		15.90,		3.50]
]


//LITHIUM BATTERY CHARGER DATA
//Syntax:
//[ 'name/model',					A,	S,	P,		Eff%,	VminForMaxP]
var chargers=[
[ 'Astroflight 109',				8,	9,	170,	,		12		],
[ 'Astroflight 109 - A123',			8,	10,	170,	,		12		],
	
[ 'Duratrax ICE',					8,	4,	120,	,		11		],

[ 'E-Station BC8DP',				10,	8,	180,	,		12		],

[ 'FMA Cellpro 10s',				10,	10,	260,	,		15.7	],
[ 'FMA Cellpro 4s Gold',			4,	4,	58,		,		12		],
[ 'FMA Cellpro Multi4',				4,	5,	58,		,		12		],
[ 'FMA PowerLab 8 (v2)',			40,	10,	1344,	,		26.35	],

[ 'Hyperion EOS 0606i',				6,	6,	50,		,		11		],
[ 'Hyperion EOS 0610i DUO (2Ch)',	10,	6,	180,	,		15		],
[ 'Hyperion EOS 0610i NET',			10,	6,	250,	,		15		],
[ 'Hyperion EOS 0615i DUO3 (2Ch)',	15,	6,	180,	,		14.5	],
[ 'Hyperion EOS 0615i DUO3+ (2Ch)',	15,	6,	300,	,		24		],
[ 'Hyperion EOS 0720i NET3-AD',		20,	7,	150,	,		10.5	],
[ 'Hyperion EOS 0720i NET3',		20,	7,	250,	,		14.5	],
[ 'Hyperion EOS 0720i SDUO3 (2Ch)',	20,	7,	500,	,		24		],
[ 'Hyperion EOS 1210i',				10,	12,	180,	,		11		],
[ 'Hyperion EOS 1420i NET3',		20,	14,	550,	,		24		],
[ 'Hyperion EOS 5i DP',				5,	5,	50,		,		11		],
[ 'Hyperion EOS 5i DP AC/DC',		5,	5,	50,		,		11		],
[ 'Hyperion EOS 7i',				7,	5,	120,	,		11		],

[ 'Protek ICharger 208B',			20,	8,	350,	,		18		],
[ 'Protek ICharger 1010B',			10,	10,	300,	,		13.5	],
[ 'Protek ICharger 106B',			10,	6,	250,	,		13.5	],
[ 'Protek ICharger 206B',			20,	6,	300,	,		18		],
[ 'Protek ICharger 3010B',			30,	10,	1000,	,		23		],

[ 'Imax B5',						5,	5,	50,		,		11		],
[ 'Imax B6',						5,	6,	50,		,		11		],
[ 'Imax B6AC',						5,	6,	50,		,		11		],
[ 'Imax B8',						7,	8,	150,	,		11		],

[ 'MRC 989',						10,	8,	120,	,		15		],
	
[ 'ThunderPower 1010D',				10,	10,	210,	,		11		],

[ 'TME Xtrema',						8,	10,	170,	0.8,	10		]
]


//DOGBONE DIMENSION TABLE
//Syntax:
//['Make/Model',		L(overall),	L(p-p),	Dshaft,	Dxpin,	Dball, 	Lxpin]
//                  	D1			D2		D3		D4		D5		D6
var dogbones=[
['Ofna Hyper7 (FC)',	97.00,		90.00,	4.80,	3.00,	7.90,	12.70],
['Ofna Hyper7 (RC)',	104.00,		97.00,	4.80,	3.00,	7.90,	12.70],
['XTM Mammoth (FC)',	182.00,		175.00,	5.02,	3.03,	7.84,	13.83]
]


//DRIVE TYPES
//Syntax:
//[ value, 'text' ]
var drive=[
[0.75, '4 WD'],
[0.85, '2 WD (with transmission)'],
[0.95, '2 WD (direct drive)']
]


/********************************************************************
XML ROUTINES.
********************************************************************/


//LOAD XML FILE, RETURNS XML OBJECT
function loadXMLFile(f){
	var file=f+'?v='+new Date().getTime(); //NO CACHING OF XML FILE!
	var error="";
	var xml;
	try{ //IE
		xml=new ActiveXObject("Microsoft.XMLDOM");
		xml.async=false;
		xml.load(file);
	}catch(e){
		try{ //FF, Opera, etc.
			xml=document.implementation.createDocument("","",null);
			xml.async=false;
			xml.load(file);
		}catch(e){
			try{ //Chrome
				var xmlhttp = new window.XMLHttpRequest();
				xmlhttp.open("GET",file,false);
				xmlhttp.send(null);
				xml = xmlhttp.responseXML.documentElement;
			}catch(e){
				//error=e.message;
				error='This browser does not support loading of the required XML data files.\n\nIf you are using these R/C tools `offline` in the Google Chrome browser, try using a different browser such as Internet Explorer or Mozilla Firefox.\n\n';
			}
		}
	}
	if(error!="")alert(error);
	else return xml;
}


//RETURNS NODE VALUE.
//x=XML OBJECT
//i=COLLECTION INDEX
//s=NODE NAME
//isNum=true/false. WILL PARSE THE NUMERICAL VALUE IF true. IF THE NUMBER IS NAN, RETURNS null INSTEAD OF NaN.
function getNodeValue(x,i,s,isNum){
	//var tmp=(x[i].getElementsByTagName(s)[0].hasChildNodes())?unescape(x[i].getElementsByTagName(s)[0].childNodes[0].nodeValue):'';
	var tmp=unescape(x[i].getElementsByTagName(s)[0].childNodes[0].nodeValue);
	if(isNum){
		tmp=parseFloat(tmp);
		if(isNaN(tmp))tmp=null;
	}
	return tmp;
}


//RETURNS NODE ATTRIBUTE VALUE.
//x=XML OBJECT
//i=COLLECTION INDEX
//s=NODE NAME
//na=ATTRIBUTE NAME
//isNum=true/false. WILL PARSE THE NUMERICAL VALUE IF true. IF THE NUMBER IS NAN, RETURNS null INSTEAD OF NaN.
function getNodeAttribute(x,i,s,na,isNum){
	tmp=x[i].getElementsByTagName(s)[0].getAttribute(na);
	if(isNum){
		tmp=parseFloat(tmp);
		if(isNaN(tmp))tmp=null;
	}
	return tmp;
}


//RETURNS PARSED motors.xml AS MULTI-DIMENSIONAL ARRAY
function parseMotorXML(){
	var p=(arguments.length==1)?arguments[0]:'';
	var a=new Array();
	var x=loadXMLFile(p+'xml/motors.xml');
	x=x.getElementsByTagName('MOTOR');
	for(var i=0;i<x.length;i++){
		a[i]=new Array();
		a[i][0]=getNodeValue(x,i,"COMPANY",0);
		a[i][1]=getNodeValue(x,i,"MODEL",0);
		a[i][2]=getNodeValue(x,i,"KV",1);
		a[i][3]=getNodeAttribute(x,i,"KV","type",1);
		a[i][4]=getNodeValue(x,i,"MAX_RPM",1);
		a[i][5]=getNodeValue(x,i,"RESISTANCE",1);
		a[i][6]=getNodeValue(x,i,"POWER",1);
		a[i][7]=getNodeValue(x,i,"POLES",1);
		a[i][8]=getNodeAttribute(x,i,"DIMENSIONS","length",1);
		a[i][9]=getNodeAttribute(x,i,"DIMENSIONS","diameter",1);
		a[i][10]=getNodeValue(x,i,"WEIGHT",1);
		a[i][11]=getNodeValue(x,i,"FLANGE_DIAMETER",1);
		a[i][12]=getNodeAttribute(x,i,"SHAFT","length",1);
		a[i][13]=getNodeAttribute(x,i,"SHAFT","diameter",1);
	}
	//return a;
	//return sortMultiArray(a,0,1)
	return sortCoModel(a);
}


//RETURNS PARSED differentials.xml AS MULTI-DIMENSIONAL ARRAY
function parseDiffXML(){
	var p=(arguments.length==1)?arguments[0]:'';
	var a=new Array();
	var x=loadXMLFile(p+'xml/differentials.xml');
	x=x.getElementsByTagName('DIFF');
	for(var i=0;i<x.length;i++){
		a[i]=new Array();
		a[i][0]=getNodeValue(x,i,"COMPANY",0);
		a[i][1]=getNodeValue(x,i,"MODEL",0);
		a[i][2]=getNodeValue(x,i,"OUTPUT",1);
		a[i][3]=getNodeValue(x,i,"INPUT",1);
	}
	return sortCoModel(a);
}


//RETURNS PARSED transmissions.xml AS MULTI-DIMENSIONAL ARRAY
function parseTransXML(){
	var p=(arguments.length==1)?arguments[0]:'';
	var a=new Array();
	var x=loadXMLFile(p+'xml/transmissions.xml');
	x=x.getElementsByTagName('TRANSMISSION');
	for(var i=0;i<x.length;i++){
		a[i]=new Array();
		a[i][0]=getNodeValue(x,i,"COMPANY",0);
		a[i][1]=getNodeValue(x,i,"MODEL",0);
		a[i][2]=getNodeValue(x,i,"T1",1);
		a[i][3]=getNodeValue(x,i,"T2",1);
		if(getNodeValue(x,i,"T3",1)!=-1){
			a[i][4]=getNodeValue(x,i,"T3",1);
			if(getNodeValue(x,i,"T4",1)!=-1){
				a[i][5]=getNodeValue(x,i,"T4",1);
			}
		}
	}
	return sortCoModel(a);
}


//RETURNS PARSED spurs.xml AS MULTI-DIMENSIONAL ARRAY
function parseSpursXML(){
	var p=(arguments.length==1)?arguments[0]:'';
	var a=new Array();
	var x=loadXMLFile(p+'xml/spurs.xml');
	x=x.getElementsByTagName('SPUR');
	for(var i=0;i<x.length;i++){
		a[i]=new Array();
		a[i][0]=getNodeValue(x,i,"COMPANY",0);
		a[i][1]=getNodeValue(x,i,"MODEL",0);
		a[i][2]=getNodeValue(x,i,"PITCH",0);
		a[i][3]=getNodeValue(x,i,"TEETH",1);
	}
	return sortCoModel(a);
}


//RETURNS PARSED tires.xml AS MULTI-DIMENSIONAL ARRAY
function parseTiresXML(){
	var p=(arguments.length==1)?arguments[0]:'';
	var a=new Array();
	var x=loadXMLFile(p+'xml/tires.xml');
	x=x.getElementsByTagName('TIRE');
	for(var i=0;i<x.length;i++){
		a[i]=new Array();
		a[i][0]=getNodeValue(x,i,"COMPANY",0);
		a[i][1]=getNodeValue(x,i,"MODEL",0);
		a[i][2]=getNodeValue(x,i,"SCALE",0);
		a[i][3]=getNodeValue(x,i,"TYPE",0);
		a[i][4]=getNodeValue(x,i,"DIAMETER",1);
	}
	return sortCoModel(a);
}


/************************************************************************
ARRAY ROUTINES
************************************************************************/


//COMBINE ARRAYS INTO ONE ARRAY
function concatArray(a1,a2){
	var ta=new Array();
	for(i=0;i<a1.length;i++)ta[ta.length]=a1[i];
	for(j=0;j<a2.length;j++)ta[ta.length]=a2[j];
	return ta;
}


//FIND THE POSITION OF THE LARGEST TEXT STRING IN AN ARRAY FOR ALIGNMENT PURPOSES
function findLargestStr(arry,p){
	var s=0;
	arry=eval(arry);
	for(var i=0;i<arry.length;i++){
		if(arry[i][p])s=Math.max(s,arry[i][p].length);
	}
	return s;
}


//FIND THE LARGEST NUMBER VALUE IN AN ARRAY
function findLargestNum(arry,pos){
	var n=0;
	arry=eval(arry);
	for(i=0;i<arry.length;i++)n=Math.max(n,arry[i][pos]);
	return n;
}


//SORTS A MULTIDIMENSIONAL ARRAY. RETURNS SORTED ARRAY.
//a = MULTI-DIM ARRAY TO SORT
//n = POSITION IN SUB-ARRAY TO SORT BY
//d = SORT ORDER. 1:asc 2:desc
function sortMultiArray(a,n,d){
	//EMBEDDED ASCENDING SORT FUNCTION.
	function subsortA(a,b){
		if(typeof a[n]=="number" && typeof b[n]=="number"){
			return (a[n] - b[n])
		}else if (typeof a[n]=="string" && typeof b[n]=="string"){
			var x=a[n].toLowerCase();
			var y=b[n].toLowerCase();
			return (x<y)?-1:((x>y)?1:0);
		}else return 0;
	}
	//EMBEDDED DESCENDING SORT FUNCTION.
	function subsortD(a,b){
		if(typeof a[n]=="number" && typeof b[n]=="number"){
			return (b[n] - a[n])
		}else if (typeof a[n]=="string" && typeof b[n]=="string"){
			var x=a[n].toLowerCase();
			var y=b[n].toLowerCase();
			return (x>y)?-1:((x<y)?1:0);
		}else return 0;
	}
	//CREATE A COPY OF THE ARRAY
	var ta=a.slice();
	//RETURN SORTED ARRAY
	if(d==1)return ta.sort(subsortA);
	else if(d==2)return ta.sort(subsortD);
	else return ta;
}


// TESTS TO SEE IF v EXISTS IN POSITION p OF ARRAY a
// RETURNS true IF IT DOES EXIST, false IF IT DOES NOT
function isInArray(a,p,v){
	var lst=a.slice();
	var rv=false;
	for(i=0;i<lst.length;i++){
		if(lst[i]==v){
			 rv=true;
			 i=lst.length;
		}
	}
	return rv;
}


// RETURNS AN ARRAY CONTAINING MATCHES WHERE v APPEARS IN POSITION p OF MULTI-DIM ARRAY a
function searchArray(a,p,v){
	var lst=a;
	var rA=new Array();
	for(i=0;i<lst.length;i++){
		if(lst[i][p]==v){
			 rA[rA.length]=lst[i];
		}
	}
	if(rA.length==0)rA=false;
	return rA;
}


//USED WITH getCompanyList FUNCTION.
//RETURNS true IF COMPANY v IS IN ARRAY a, OTHERWISE RETURNS false.
function subGetCompanyList(a,v){
	var r=false;
	for(i=0;i<a.length;i++){
		if(a[i]==v){
			 r=true;
			 break;
		}
	}
	return r;
}


//RETURNS ARRAY OF UNIQUE COMPANY NAMES FROM a MULTI-DIM ARRAY.
function getCompanyList(a){
	var ra=new Array();
	for(var i=0;i<a.length;i++){
		if(!subGetCompanyList(ra,a[i][0])){
			ra[ra.length]=a[i][0];
		}
	}
	return ra.sort();
}


//RETURNS MULTI-DIM ARRAY WHERE COMPANY MATCHES n
function getMatchingCompanies(a,n){
	return searchArray(a,0,n);
}


//RETURNS POSITION OF a ARRAY IN A MULTI-DIM ARRAY ma. RETURNS -1 IF NOT FOUND.
function getAPosInMDA(ma,a){
	var pos=-1;
	for(var i=0;i<ma.length;i++){
		if(ma[i]==a){
			pos=i;
			break;
		}
	}
	return pos;
}


//SORTS ARRAY a BY COMPANY THEN BY MODEL
function sortCoModel(a){
	var co=getCompanyList(a).sort();
	var ra=new Array();
	var ta1;
	var ta2;
	for(var i=0;i<co.length;i++){
		ta1=searchArray(a,0,co[i]);
		ta2=sortMultiArray(ta1,1,1);
		for(var j=0;j<ta2.length;j++){
			ra[ra.length]=ta2[j];
		}
	}
	return ra;
}

/************************************************************************
FORM FUNCTIONS
************************************************************************/


//CHANGES AN IMAGE BASED ON RADIO BUTTON VALUE
//'el' is USUALLY this AND img IS THE NAME OF THE IMAGE
function changeImageFromRadio(el,img){
	document.images[img].src='images/'+el.value;
}


//CHANGES AN IMAGE BASED ON SELECT BOX VALUE
//'el' is USUALLY this AND img IS THE NAME OF THE IMAGE
function changeImageFromSelect(el,img){
	document.images[img].src='images/'+el.value;
}


//RETURNS THE TEXT VALUE FOR A SET OF RADIO BUTTONS. f="formName", n="radioButtonName"
function getRadioValue(f,n){
	var eA=document.forms[f].elements;
	for(var i=0;i<eA.length;i++){
		if(eA[i].name==n){
			if(eA[i].checked)return eA[i].value;
		}
	}
}


//DISABLES OPTION FOR A SET OF RADIO BUTTONS.
//f: "formName"
//n: "radioButtonName"
//v: "value" which will be disabled/enabled. Use '*' to disable all options.
//which: 1=enable, 0=disable
function disableRadioButton(f,n,v,which){
	for(var i=0;i<document.forms[f][n].length;i++){
		if(document.forms[f][n][i].value==v || v=='*'){
			document.forms[f][n][i].disabled=(which)?true:false;
		}
	}
}


//SELECTS AND EXECUTES ONCLICK FUNCTION FOR A SPECIFIC RADIO BUTTON VALUE
//f: "formName"
//n: "radioButtonName"
//v: "valueToActivate"
function clickRadioButton(f,n,v){
	for(var i=0;i<document.forms[f][n].length;i++){
		if(document.forms[f][n][i].value==v){
			document.forms[f][n][i].checked=true;
			document.forms[f][n][i].onclick();
		}
	}
}


//CLEARS A RADIO BUTTON GROUP
function clearRadio(which){
	for(i=0;i<which.length;i++)if(which[i].checked==true)which[i].checked = false;
}


//PAD A STRING WITH EMPTY SPACES FOR ALIGNMENT PURPOSES
function padString(str,n){
	for(j=str.length;j<=n-1;j++)str+="&nbsp;";
	return str;
}


//RETURNS FIRST POSITION OF str IN sel SELECT ELEMENT.
function getPosOfStrInSelect(str,sel,f){
	var rv=-1;
	for(var i=0;i<document.forms[f][sel].length;i++){
		if(document.forms[f][sel][i].value==str){
			rv=i;
			break;
		}
	}
	return rv;
}


/************************************************************************
MISC ROUTINES
************************************************************************/


//CHECK THE NUMERICAL VALIDITY OF A STRING
//IF NAN: RETURNS "X" BY DEFAULT. IF SECOND ARGUMENT EXISTS, RETURNS THAT INSTEAD.
//IF OK: RETURNS THE PARSED NUMBER
function checkNum(n){
	var rv=(arguments.length>1)?arguments[1]:"X";
	n=n.replace(',','.');
	if(typeof parseFloat(n) != "number" || isNaN(parseFloat(n)))return rv;
	else return parseFloat(n);
}


//CONVERT A ONE-DIGIT NUMBER TO A STRING AND PAD THE NUMBER WITH TRAILING ZEROS FOR ALIGNMENT PURPOSES
function padNum(n,p){
	n+="";
	if(n.length==1)n=n+".";
	while(n.length<p+2)n+="0";
	return n;
}


//CONVERT ANY NUMBER TO A STRING AND PAD THE NUMBER WITH TRAILING ZEROS FOR ALIGNMENT PURPOSES
function padNum2(n,p){
	n+="";
	if(n.indexOf(".")<0)n+=".0";
	while(n.length-n.indexOf(".")<p+1)n+="0";
	return n;
}


//CONVERT ANY NUMBER TO A STRING AND PAD THE NUMBER WITH *PRECEEDING* ZEROS
function padNum3(n,p){
	n+="";
	while(n.length<p)n="0"+n;
	return n;
}


//ROUND A NUMBER (n) TO A PRECISION (p)
function round(n,p){
	p=eval('1e'+p);
	return Math.round(n*p)/p;
}


//USED TO TEST FOR EMPTY STRING AND RETURNS '&nbsp;' INSTEAD OF EMPTY STRING.
//IF A SECOND ARGUMENT PRESET, RETURNS THAT INSTEAD.
function testEmpty(f){
	var dv=(arguments.length>1)?arguments[1]:"&nbsp;";
	return (f=="")?dv:f;
}


//USED TO TEST FOR EMPTY STRING AND RETURN 0 INSTEAD OF EMPTY STRING.
function testEmptyN(f){
	return (f=="")?0:f;
}


//PRELOAD SECONDARY IMAGES.
function loadImages(){
	var t='<div style="position:absolute; top:-100px; left:0px; display:none; width:100px; height:100px; overflow:hidden">';
	if(typeof arguments[0]=="object"){
		//SINGLE ARGUMENT IS AN ARRAY OF IMAGES
		for(i=0;i<arguments[0].length;i++)t+='<img src="'+arguments[0][i]+'">';
	}else{
		//EACH ARGUMENT IS A SEPERATE IMAGE
		var imga=new Array();
		for(i=0;i<arguments.length;i++)t+='<img src="'+arguments[i]+'">';
	}
	document.write(t+'</div>');
}


//MOVE AN OBJECT
function moveObjTo(obj,x,y){
	obj.style.left=x+"px";
	obj.style.top=y+"px";
}


//SHOW AN ARBITRARY NUMBER OF ELEMENTS BY ID
function showIDs(){
	for(var i=0;i<arguments.length;i++)document.getElementById(arguments[i]).style.display="block";
}


//HIDE AN ARBITRARY NUMBER OF ELEMENTS BY ID
function hideIDs(){
	for(var i=0;i<arguments.length;i++)document.getElementById(arguments[i]).style.display="none";
}


//WRITE TEXT TO A DIV ELEMENT
function writeToDiv(id,txt){
	document.getElementById(id).innerHTML=txt;
}


//GET ELEMENT X COORDINATE
function getX(e){
	var l=0;
	var el=0;
	if(document.getElementById)el=document.getElementById(e);
	else if(document.all)el=document.all[e];
	if(el.offsetParent){
		while(el){
			l+=el.offsetLeft;
			el=el.offsetParent;
		}
	}else if(el.x)l+=el.x;
	return l;
}


//GET ELEMENT Y COORDINATE
function getY(e){
	var t=0;
	var el=0;
	if(document.getElementById)el=document.getElementById(e);
	else if(document.all)el=document.all[e];
	if(el.offsetParent){
		while(el){
		t+=el.offsetTop;
		el=el.offsetParent;
		}
	}else if(el.y)t+=el.y;
	return t;
}


//GET ELEMENT HEIGHT
function getH(e) {
	var h=0;
	var el=0;
	if(document.getElementById)el=document.getElementById(e);
	else if(document.all)el=document.all[e];
	if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))h=el.style.pixelHeight;
	else h=el.offsetHeight;
	return h;
}


//GET ELEMENT WIDTH
function getW(e) {
	var w=0;
	var el=0;
	if(document.getElementById)el=document.getElementById(e);
	else if(document.all)el=document.all[e];
	if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))w=el.style.pixelWidth;
	else w=el.offsetWidth;
	return w;
}


function getWinWidth(){
	if(window.innerWidth!=null)return window.innerWidth;
	else if(document.documentElement&&document.documentElement.clientWidth)return document.documentElement.clientWidth;
	else if(document.body!=null)return document.body.clientWidth;
	else return 0;
}


function getWinHeight(){
	if(window.innerHeight!=null)return window.innerHeight;
	else if(document.documentElement&&document.documentElement.clientHeight)return document.documentElement.clientHeight;
	else if(document.body!=null)return document.body.clientHeight;
	else return 0;
}


function getScrollLeft(){
	if(typeof window.pageXOffset!='undefined')return window.pageXOffset;
	else if(document.documentElement&&document.documentElement.scrollLeft)return document.documentElement.scrollLeft;
	else if(document.body.scrollLeft)return document.body.scrollLeft;
	else return 0;
}


function getScrollTop(){
	if(typeof window.pageYOffset!='undefined')return window.pageYOffset;
	else if(document.documentElement&&document.documentElement.scrollTop)return document.documentElement.scrollTop;
	else if(document.body.scrollTop)return document.body.scrollTop;
	else return 0;
}



/************************************************************************
PSEUDO SELECT START
USAGE:
	1: ADD PSEUDO SELECT DIV: <div class="select|minselect" id="selectID">&nbsp;</div>
	2: ADD ASSOCIATED INPUT ELEMENT: <input type="text" class="entries" name="targetID" id="targetID" onchange="resetSelectLists('selectID');" />
	3: ADD window.onload BLOCK AND A LINE LIKE THIS FOR EACH PSEUDO SELECT:
	   $ps.initPseudoSelect('selectID', 'targetID', 'InitText', textArray, valueArray, enableSearch );
	
	PARAMETERS FOR $ps.initPsuedoSelect:

	selectID		ID OF DIV WITH CLASS OF SELECT OR MINSELECT
	targetID		ID OF INPUT BOX TO BE FILLED IN WHEN SOMETHING SELECTED. SET TO '' TO NOT FILL IN A TEXT BOX.
	initText 		INITIAL DEFAULT DISPLAY TEXT. USE '' IF USING ref.setInitialValue(). SEE NOTE 1 BELOW FOR MINIMAL VERSION.
	textArray 	 	ARRAY OF SELECT BOX CHOICES. WILL APPEAR AS TEXT IN selectID WHEN CHOSEN.
	valueArray	 	ARRAY OF SELECT BOX RETURN VALUES. WILL APPEAR AS VALUE IN targetID WHEN CHOSEN.
	enableSearch	WHETHER (true) OR NOT (false) THE AJAX-LIKE SEARCH FUNCTION WILL BE USED.

	NOTE 1:
	AN ALTERNATE MINIMAL DROPDOWN BUTTON IS AVAILABLE, WHICH IS JUST A SMALL DROPDOWN BUTTON WITH NO TEXT.
	- THE initText PARAMETER MUST BE '#'
	- THE DIV CLASSNAME (IN THE HTML) MUST BE 'minselect' INSTEAD OF 'select'

	THE FOLLOWING CSS RULES ARE USED:

	#suggOuter: 		OUTER CONTAINER OF DROPDOWN CONTENT
	div#suggContent		INNER DROP DOWN CONTAINER
	div#suggTitle		CONTENT SEARCH TITLE BAR
	div.choices			DROP DOWN CHOICES
	div.choicesH		DROP DOWN CHOICES HOVER
	span.choicesMatch	DROP DOWN TEXT WHICH MATCHES SEARCH TEXT
	div.choicesHeader	USED IN SPECIAL CIRCUMSTANCES WHERE DROP DOWN LIST HAS HEADERS
	div.choicesNone		TEXT WHEN NO MATCHES FOR SEARCH TEXT IS FOUND
	div.minselect		PSEUDO SELECT BOX - MINIMAL VERSION
	div.select			PSEUDO SELECT BOX
	input#select_entry	SEARCH INPUT AREA
	div.ddbutton		DROP DOWN BUTTON

	EXPOSED PROPERTIES/METHODS. IN ALL CASES, ref IS A VARIABLE CONTAINING THE RETURN VALUE OF THE $ps.initPseudoSelect CONSTRUCTOR:
	
	ref.value:					THE CURRENT VALUE. IS INITIALLY null UNLESS ref.setInitialValue() IS CALLED.
	
	ref.setInitialValue(idx):	SETS THE INITIAL VALUE AND TEXT. idx IS THE INDEX VALUE OF THE textA AND valueA ARRAYS.
						   		* MAKE SURE THE initText IS '' OR '#' FOR THE RESET FUNCTION TO WORK CORRECTLY.
	
	ref.setValue(idx):   		SETS THE VALUE AND TEXT.  idx IS THE INDEX VALUE OF THE textA AND valueA ARRAYS.
						  		* DOES NOT FIRE THE onValueSet() EVENT HANDLER.
						  		
	ref.onValueSet=function():	EVENT HANDLER FUNCTION TO EXECUTE WHEN THE VALUE IS SET.

*************************************************************************/

//WRITES PSEUDO SELECT CONTENT DIV TO THE PAGE
document.write('<div id="suggOuter" onmouseover="clearTimeout($ps.timer)" onmouseout="$ps.timer=setTimeout(\'$ps.hideSuggest()\',500)"><div id="suggTitle"> Search: <input type="text" id="select_entry" onkeyup="" value="" /></div><div id="suggContent"></div></div>');

var $ps={

	//SOME VARS...
	'currF':null,
	'eventSet':null,
	'timer':null,

	//INITIALIZES PSEUDO SELECT LISTS
	'initPseudoSelect':function(selectID, targetID, initText, textA, valueA, enableSearch){
		var el=document.getElementById(selectID);
		el.selectID=selectID;
		el.targetID=targetID;
		el.initText=initText;
		el.textA=textA;
		el.valueA=valueA;
		el.enableSearch=enableSearch;
		el.value=null;
		el.innerHTML='';
		el.ssv_idx=null;
		el.onmouseover=function(){
			clearTimeout($ps.timer);
		}
		el.onmouseout=function(){
			$ps.timer=setTimeout('$ps.hideSuggest()',500);
		}
		el.setInitialValue=function(idx){
			this.ssv_idx=idx;
			this.value=valueA[idx];
			if(this.initText!='#')this.getElementsByTagName('span')[0].innerHTML=this.textA[idx];
		}
		el.setValue=function(idx){
			this.value=valueA[idx];
			if(this.initText!='#')this.getElementsByTagName('span')[0].innerHTML=this.textA[idx];
		}
		el.onValueSet=null;
		var newel=document.createElement('span');
		newel.innerHTML=(initText=='#')?'&nbsp;':initText;
		el.appendChild(newel);
		if(initText!='#'){
			newel=document.createElement('div');
			newel.setAttribute('className','ddbutton');
			newel.setAttribute('class','ddbutton');
			el.appendChild(newel);
		}
		el.onmousedown=function(){$ps.toggleSuggest(this)};
		//SETS WINDOW RESIZE EVENT HANDLER.
		if(!$ps.eventSet){
			if(window.addEventListener){ //W3C
					window.addEventListener('resize',$ps.positionSuggest,false);
			}
			else if(window.attachEvent){ //<IE9
					window.attachEvent('onresize',$ps.positionSuggest);
			}else{ //EVERYTHING ELSE. NOT EVEN SURE IF THIS WILL WORK...
				var dors=window.onresize;
				window.resize=function(){
					if(typeof dors=="function")dors();
					$ps.positionSuggest;
				}
			}
			$ps.eventSet=true;
		}
		return el;
	},

	//RESETS PSUEDO SELECT LISTS.
	//IF ARGUMENTS (LIST OF ID STRINGS) ARE PRESENT, WILL RESET JUST THOSE. IF NO ARGUMENTS PRESENT, WILL RESET ALL.
	'resetSelectLists':function(){
		var els=new Array();
		if(arguments.length>0){
			for(var i=0;i<arguments.length;i++){
				els[els.length]=document.getElementById(arguments[i]);
			}
		}else{
			var tels=document.getElementsByTagName('div');
			for(var i=0;i<tels.length;i++){
				if(tels[i].className=="select"){
					els[els.length]=tels[i];
				}
			}
		}
		for(var i=0;i<els.length;i++){
			try{
				if(els[i].initText!=''){
					if(els[i].initText!='#')els[i].getElementsByTagName('span')[0].innerHTML=els[i].initText;
					els[i].value=null;
				}else{
					els[i].setValue(els[i].ssv_idx);
				}
			}catch(e){}
		}
	},

	//HIDES THE SUGGEST BOX...
	'hideSuggest':function(){
		$ps.currF=null;
		document.getElementById('suggOuter').style.display="none";
		document.getElementById('suggContent').innerHTML="";
		document.getElementById('select_entry').value="";
	},

	//SHOWS THE SUGGEST BOX OR HIDES IT IF ALREADY SHOWN
	'toggleSuggest':function(el){
		if(document.getElementById('suggOuter').style.display=="block" && $ps.currF==el){
			$ps.hideSuggest();
		}else{
			document.getElementById('suggTitle').style.display="block";
			$ps.currF=el;
			$ps.suggest();
		}
	},

	//BUILDS LIST OF SELECTABLE ITEMS. ALSO PROVIDES SEARCH FUNCTION IF ENABLED.
	'suggest':function(){
		var rv='';
		if(!$ps.currF.enableSearch)document.getElementById('suggTitle').style.display="none";
		var srch=document.getElementById('select_entry')
		document.getElementById('select_entry').onkeyup=function(){$ps.suggest()};
		for(var i=0;i<$ps.currF.textA.length;i++){
			if($ps.currF.valueA[i]=='*'){
				rv+='<div class="choicesHeader">'+$ps.currF.textA[i]+'</div>';
			}else{
				if($ps.currF.enableSearch){
					if($ps.currF.textA[i].toUpperCase().indexOf(srch.value.toUpperCase())!=-1){
						rv+='<div class="choices" onmouseup="$ps.setValue('+i+')" onmouseover="this.className=\'choicesH\'" onmouseout="this.className=\'choices\'">'+$ps.currF.textA[i].toUpperCase().replace(srch.value.toUpperCase(),'<span class="choicesMatch">'+srch.value.toUpperCase()+'</span>')+'</div>';
					}
				}else{
					rv+='<div class="choices" onmouseup="$ps.setValue('+i+')" onmouseover="this.className=\'choicesH\'" onmouseout="this.className=\'choices\'">'+$ps.currF.textA[i]+'</div>';
				}
			}
		}
		if(rv=='')rv='<div class="choicesNone">No matches found...</div>';
		document.getElementById('suggContent').style.height="auto";	//FREES THE CONTENT TO BE AS BIG AS NEEDED DEPENDING ON CONTENT
		document.getElementById('suggContent').innerHTML=rv;
		document.getElementById('suggOuter').style.display="block";
		document.getElementById('suggContent').style.height=Math.max(20,Math.min(200,getH('suggContent')))+"px"; //MAKES THE CONTENT BETWEEN 20PX TO 200PX HIGH.
		document.getElementById('suggContent').style.width="100%"; //IE FIX FOR HORIZONTAL SCROLLBARS
		if(document.getElementById('suggTitle').style.display!="none")setTimeout("document.getElementById('select_entry').focus()",100);
		document.getElementById('suggContent').scrollTop=0; //ALWAYS STARTS THE SCROLL AT THE TOP.
		$ps.positionSuggest();
	},

	//SETS SUGGEST CONTENT AND POSITIONS IT.
	'positionSuggest':function(){
		if($ps.currF!=null){
			document.getElementById('suggOuter').style.top=$ps.getY($ps.currF.selectID)+$ps.getH($ps.currF.selectID)+"px";
			document.getElementById('suggOuter').style.left=$ps.getX($ps.currF.selectID)+"px";
		}
	},

	//SETS THE TARGET FIELD VALUE WHEN VALUE IS SELECTED
	'setValue':function(n){
		$ps.currF.value=$ps.currF.valueA[n];
		if($ps.currF.targetID!='')document.getElementById($ps.currF.targetID).value=$ps.currF.valueA[n];
		if($ps.currF.initText!='#')document.getElementById($ps.currF.selectID).getElementsByTagName('span')[0].innerHTML=$ps.currF.textA[n];
		if(typeof $ps.currF.onValueSet=="function"){
			try{
				$ps.currF.onValueSet();
			}catch(e){};
		}
		$ps.hideSuggest();
	},

	//RETURNS DIFFERENTIAL ARRAY.
	'getDiffData':function(which){
		var a=new Array();
		for(var i=0;i<Differential.length;i++){
			if(which=='t'){
				a[a.length]=Differential[i][0]+' '+Differential[i][1]+' - '+$ps.padNum($ps.round(Differential[i][2]/Differential[i][3],2),2)+':1';
			}else{
				a[a.length]=Differential[i][2]/Differential[i][3];
			}
		}
		return a;
	},

	//RETURNS SPUR ARRAY.
	'getSpurData':function(which){
		var a=new Array();
		for(var i=0;i<Spur.length;i++){
			if(which=='t'){
				a[a.length]=Spur[i][0]+' '+Spur[i][1]+' - '+Spur[i][3]+'T';
			}else{
				a[a.length]=Spur[i][3];
			}
		}
		return a;
	},

	//RETURNS TIRES ARRAY.
	'getTireData':function(which){
		var a=new Array();
		for(var i=0;i<Tires.length;i++){
			if(which=='t'){
				a[a.length]=Tires[i][0]+' '+Tires[i][1]+' - '+Tires[i][4]+'&quot;';
			}else{
				a[a.length]=Tires[i][4];
			}
		}
		return a;
	},

	//RETURNS MOTOR ARRAY.
	'getMotorData':function(which){
		var a=new Array();
		for(var i=0;i<kv.length;i++){
			if(which=='t'){
				a[a.length]=kv[i][0]+' '+kv[i][1]+' - '+kv[i][2]+'kv'; // ('+((kv[i][3]==0)?kvt='U':(kv[i][3]==1)?'L':'?')+')';
			}else{
				a[a.length]=i;
			}
		}
		return a;
	},

	//RETURNS TRANSMISSION ARRAY.
	'getTransData':function(which){
		var a=new Array();
		var ratio=0;
		for(var i=0;i<Transmission.length;i++){
			if(Transmission[i].length==4)ratio=Transmission[i][2]/Transmission[i][3];
			else if(Transmission[i].length==5)ratio=(Transmission[i][2]/Transmission[i][3])*(Transmission[i][3]/Transmission[i][4]);
			else if(Transmission[i].length==6)ratio=(Transmission[i][2]/Transmission[i][3])*(Transmission[i][4]/Transmission[i][5]);
			if(which=='t'){
				a[a.length]=Transmission[i][0]+' '+Transmission[i][1]+' - '+$ps.padNum($ps.round(ratio,2),2)+':1';
			}else{
				a[a.length]=ratio;
			}
		}
		return a;
	},

	//RETURNS VOLTAGE ARRAY.
	'getSimpleVoltsData':function(which){
		var a=new Array();
		for(var i=1;i<=20;i++){
			if(which=='t'){
				a[a.length]=i+'s Lipo - '+$ps.padNum($ps.round(i*3.7,1),1)+'v';
			}else if(which=='v'){
				a[a.length]=$ps.round(i*3.7,2);
			}
		}
		return a;
	},

	//RETURNS VOLTAGE ARRAY
	'getVoltsData':function(which){
		var a=new Array();
		if(which=='t'){
			for(var i=0;i<voltagesT.length;i++)a[a.length]=voltagesT[i];
		}else{
			for(var i=0;i<voltagesV.length;i++)a[a.length]=voltagesV[i];
		}
		return a;
	},

	//RETURNS CELLCOUNT ARRAY
	'getCellsData':function(which){
		var a=new Array();
		if(which=='t'){
			for(var i=1;i<=cellCount;i++)a[a.length]=i+' cell'+((i>1)?'s':'');
		}else{
			for(var i=1;i<=cellCount;i++)a[a.length]=i;
		}
		return a;
	},

	//RETURNS DRIVE TYPE ARRAY.
	'getDriveData':function(which){
		var a=new Array();
		for(var i=0;i<drive.length;i++){
			if(which=='t'){
				a[a.length]=drive[i][1];
			}else{
				a[a.length]=drive[i][0];
			}
		}
		return a;
	},

	//RETURNS GEAR PITCH ARRAY.
	'getPitchData':function(which){
		var a=new Array();
		for(var i=0;i<pitch.length;i++){
			if(which=='t'){
				a[a.length]=pitch[i][0];
			}else{
				a[a.length]=pitch[i][1];
			}
		}
		return a;
	},

	//RETURNS BALANCE CONNECTOR ARRAY.
	'getBalanceData':function(which){
		var a=new Array();
		for(var i=0;i<balConn.length;i++){
			if(which=='t'){
				a[a.length]=balConn[i][1];
			}else{
				a[a.length]=balConn[i][0];
			}
		}
		return a;
	},

	'getChargerData':function(which){
		var a=new Array();
		for(var i=0;i<chargers.length;i++){
			if(which=='t'){
				a[a.length]=chargers[i][0];
			}else{
				a[a.length]=i;
			}
		}
		return a;
	},

	//GET ELEMENT X COORDINATE
	'getX':function(e){
		var l=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if(el.offsetParent){
			while(el){
				l+=el.offsetLeft;
				el=el.offsetParent;
			}
		}else if(el.x)l+=el.x;
		return l;
	},

	//GET ELEMENT Y COORDINATE
	'getY':function(e){
		var t=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if(el.offsetParent){
			while(el){
			t+=el.offsetTop;
			el=el.offsetParent;
			}
		}else if(el.y)t+=el.y;
		return t;
	},

	//GET ELEMENT HEIGHT
	'getH':function(e) {
		var h=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))h=el.style.pixelHeight;
		else h=el.offsetHeight;
		return h;
	},

	//CONVERT ANY NUMBER TO A STRING AND PAD THE NUMBER WITH TRAILING ZEROS FOR ALIGNMENT PURPOSES
	'padNum':function(n,p){
		n+="";
		if(n.indexOf(".")<0)n+=".0";
		while(n.length-n.indexOf(".")<p+1)n+="0";
		return n;
	},

	//ROUND A NUMBER (n) TO A PRECISION (p)
	'round':function(n,p){
		p=eval('1e'+p);
		return Math.round(n*p)/p;
	}

}


/************************************************************************
SLIDER BUTTONS
************************************************************************/

var $sb={
	'currID':null,
	'xOffset':0,
	'yOffset':0,
	'eventSet':false,

	// initButton
	//
	// INITIALIZES SLIDER BUTTONS. RETURNS BUTTON ELEMENT REFERENCE.
	// PARAMETERS:
	// trackID=   ID OF TRACK DIV
	// buttonID=  ID OF BUTTON. THE ELEMENT WILL BE AUTO-ADDED VIA DOM BUT NEED A KNOWN ID FOR STYLING BGIMAGE AND DIMENSIONS
	// minR=      MIN TRACK VALUE
	// maxR=      MAX TRACK VALUE
	// barType=   "H" FOR HORIZONTAL, "V" FOR VERTICAL
	//
	// EXPOSED PROPERTIES/METHODS:
	// ref.W/ref.H:            WIDTH/HEIGHT OF BUTTON
	// ref.trackW/ref.trackH:  WIDTH/HEIGHT OF TRACK
	// ref.getValue():         RETURNS COMPUTED X/Y COORD OF THE BUTTON IN RELATION TO THE TRACK USING MIN/MAX SETTINGS. IF MIN/MAX NOT SET, RETURNS null.
	// ref.setValue(v[,flag]): SETS THE VALUE IN RELATION TO MIN/MAX RANGE. OPTIONAL flag ARGUMENT DETERMINES IF ref.onValueSet() METHOD IS CALLED (true) OR NOT (false).
	// ref.onValueSet(func):   IF SET, EXECUTES func() WHEN VALUE IS CHANGED (AS MOUSE MOVED).
	// ref.setSnapPos(pos):    SETS THE VALUE AT WHICH THE BUTTON WILL SNAP BACK TO ON MOUSE RELEASE.
	// ref.resetPosition():    RESETS THE BUTTON POSITION, BUT ONLY IF ref.snapPos IS NOT SET (IS null).
	// ref.setMinMax(min,max): SETS THE MIN AND MAX RETURN VALUES AND RECALCULATES FORMULA FOR getValue METHOD.
	//
	// IN ALL CASES, ref IS A VARIABLE ASSIGNED TO THE RETURN VALUE OF THE INIT CALL.
    // TRACK ID SHOULD HAVE #<TRACKID> CSS RULE THAT SPECIFIES THE BGIMAGE, HEIGHT, WIDTH, & POSITION.
    // **** NOTE: SLIDERS CANNOT BE INSIDE AN ELEMENT WITH CSS "DISPLAY" SET TO NONE! USE "VISIBILITY" INSTEAD OF DISPLAY.

	'initButton':function(trackID,buttonID,minR,maxR,barType){
		var tr_el=document.getElementById(trackID);
		var b_el=document.createElement('div');
		b_el.id=buttonID;
		b_el.trackID=trackID;
		b_el.style.position="absolute";
		b_el.style.cursor="pointer";
		tr_el.appendChild(b_el);
		b_el.snapPos=null;
		b_el.barType=barType;
		b_el.minValue=minR; b_el.maxValue=maxR;
		b_el.W=$sb.getW(b_el.id); b_el.H=$sb.getH(b_el.id);
		b_el.trackW=$sb.getW(trackID); b_el.trackH=$sb.getH(trackID);
		b_el.style.left="0px"; b_el.style.top="0px";
		b_el.setSnapPos=function(sp){this.snapPos=sp;}
		b_el.resetPosition=function(){
			if(this.snapPos!=null)this.setValue(this.snapPos);
			$sb.currID=null;
		}
		b_el.onValueSet=null;
		b_el.setMinMax=function(mn,mx){
			this.minValue=mn;
			this.maxValue=mx;
		}
		b_el.getValue=function(){
			if(this.barType=="H"){
				var divider=(this.trackW-this.W)/(this.maxValue-this.minValue);
				return (($sb.getX(this.id)-$sb.getX(this.trackID))/divider)+this.minValue;
			}else{
				var divider=(this.trackH-this.H)/(this.maxValue-this.minValue);
				return (($sb.getY(this.id)-$sb.getY(this.trackID))/divider)+this.minValue;
			}
		}
		b_el.setValue=function(val){
			var callEvent=(arguments.length>1)?arguments[1]:true;
			val=Math.min(this.maxValue,Math.max(val,this.minValue))
			if(this.barType=="H"){
				var divider=(this.trackW-this.W)/(this.maxValue-this.minValue);
				this.style.left=Math.round((val-this.minValue)*divider)+"px";
			}else{
				var divider=(this.trackH-this.H)/(this.maxValue-this.minValue);
				this.style.top=Math.round((val-this.minValue)*divider)+"px";
			}
			if(this.onValueSet!=null && callEvent==true)this.onValueSet();
		}
		b_el.onmousedown=$sb.drgI;
		b_el.onmouseup=b_el.resetPosition;
		//SETS DOCUMENT MOUSE UP/MOVE EVENT HANDLERS (ONLY ONCE)
		if(!$sb.eventSet){
			if(document.addEventListener){ //W3C
					document.addEventListener('mouseup',function(){if($sb.currID!=null)$sb.currID.resetPosition();},false);
					document.addEventListener('mousemove',$sb.trckM,false);
			}
			else if(document.attachEvent){ //<IE9
					document.attachEvent('onmouseup',function(){if($sb.currID!=null)$sb.currID.resetPosition();});
					document.attachEvent('onmousemove',$sb.trckM);
			}else{ //EVERYTHING ELSE...
				var domu=document.onmouseup;
				var domm=document.onmousemove;
				document.onmouseup=function(){
					if(typeof domu=="function")domu();
					if($sb.currID!=null)$sb.currID.resetPosition();
				}
				document.onmousemove=function(){
					if(typeof domm=="function")domm();
					$sb.trckM(this);
				}
			}
			$sb.eventSet=true;
		}
		return b_el;
	},

	//IF DRAGGING IS ACTIVE
	'trckM':function(e){
		if($sb.currID!=null){
			if($sb.currID.barType=="H"){ //HORIZONTAL
				var x=(document.all)?event.clientX+document.body.scrollLeft:e.pageX;
				var tx=(x-$sb.xOffset)-getX($sb.currID.trackID);
				$sb.currID.style.left=Math.max(0,Math.min(tx,$sb.getW($sb.currID.trackID)-$sb.getW($sb.currID.id)))+'px';
			}else{ //VERTICAL
				var y=(document.all)?event.clientY+document.body.scrollTop:e.pageY;
				var ty=(y-$sb.yOffset)-getY($sb.currID.trackID);
				$sb.currID.style.top=Math.max(0,Math.min(ty,$sb.getH($sb.currID.trackID)-$sb.getH($sb.currID.id)))+'px';
			}
			if($sb.currID.onValueSet!=null)$sb.currID.onValueSet();
		}
		return false;
	},

	//GET INITIAL MOUSE OFFSETS
	'drgI':function(e){
		if($sb.currID==null){
			var tx=$sb.getX(this.id);
			$sb.xOffset=((document.all)?event.clientX+document.body.scrollLeft:e.pageX)-tx;
			var ty=$sb.getY(this.id);
			$sb.yOffset=((document.all)?event.clientY+document.body.scrollTop:e.pageY)-ty;
			$sb.currID=this;
			return false;
		}
	},

	//GET ELEMENT X COORDINATE
	'getX':function(e){
		var l=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if(el.offsetParent){
			while(el){
				l+=el.offsetLeft;
				el=el.offsetParent;
			}
		}else if(el.x)l+=el.x;
		return l;
	},

	//GET ELEMENT Y COORDINATE
	'getY':function(e){
		var t=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if(el.offsetParent){
			while(el){
			t+=el.offsetTop;
			el=el.offsetParent;
			}
		}else if(el.y)t+=el.y;
		return t;
	},

	//GET ELEMENT WIDTH
	'getW':function(e){
		var w=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))w=el.style.pixelWidth;
		else w=el.offsetWidth;
		return w;
	},

	//GET ELEMENT HEIGHT
	'getH':function(e){
		var h=0;
		var el=0;
		if(document.getElementById)el=document.getElementById(e);
		else if(document.all)el=document.all[e];
		if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))h=el.style.pixelHeight;
		else h=el.offsetHeight;
		return h;
	}
}


/************************************************************************
MISC APPLICATION ROUTINES
************************************************************************/


//EXPORT FORM VALUES FOR FORUM POSTING
function exportText(frm){
	var re=/\n/gi;
	var t='';
	t+='You can copy and paste the information below to post your values into a forum thread:<br \><br \>';
	t+='<form name="rcfe">';
	t+='<a href="javascript:document.forms[\'rcfe\'].rcf_export.focus();document.forms[\'rcfe\'].rcf_export.select();\">Select all...</a><br \>';
	t+='<center><textarea name="rcf_export" rows="23" cols="55" readonly="readonly" style="font-size:11px; color:black; background-color:white">';
	var e=document.forms[frm].elements;
	for(var i=0;i<e.length;i++){
		if(e[i].getAttribute('exporttext')){
			t+=''+e[i].getAttribute("exporttext");
			t+=': ';
			t+=(document.all)?e[i].value.replace(re,'<br />'):e[i].value.replace(re,' &nbsp; &nbsp; ');
			t+='\n';
		}
	}
	t+='</textarea></center>';
	t+='</form>';
	helpArray[200]=["Form Export",t];
	help(200);
}


//IMPORTS PREVIOUSLY EXPORTED FORM VALUES
function importText(frm){
	//BUILD IMPORT WINDOW
	var t='';
	t+='Copy/paste previously exported data into the area below:<br \><br \>';
	t+='<center><form name="rcfi">';
	t+='<textarea name="rcf_import" rows="23" cols="55" style="font-size:11px; color:black; background-color:white"></textarea>';
	t+='<br /><br />';
	t+='<input type="button" class="buttons" value="Import" onclick="subImportText(\''+frm+'\',document.forms[\'rcfi\'].rcf_import.value); closeHelp()" /><br /><br />';
	t+='</form></center>';
	helpArray[201]=["Form Import",t];
	help(201);
	setTimeout("document.forms['rcfi'].rcf_import.focus()",200);
}


//SUB FUNCTION FOR IMPORTING TEXT TO POPULATE THE FORM FIELDS.
function subImportText(f,t){
	try{
		//PARSE IMPORT VALUES INTO AN ARRAY
		var importArray=new Array();
		for(var i=0;i<t.split('\n').length;i++){
			importArray[i]=new Array();
			importArray[i][0]=t.split('\n')[i].split(':')[0];
			importArray[i][1]=parseFloat(t.split('\n')[i].split(':')[1]);
			if(isNaN(importArray[i][1]))importArray[i][1]='';
		}
		//GO THROUGH THE ARRAY FOR EACH FORM ELEMENT ON THE PAGE AND TRY TO POPULATE FORM VALUES
		var e=document.forms[f].elements;
		for(var i=0;i<importArray.length;i++){
			for(var j=0;j<e.length;j++){
				if(e[j].getAttribute('exporttext')==importArray[i][0] &&e[j].getAttribute('output')!='true'){
					e[j].value=importArray[i][1];
				}
			}
		}
	}catch(err){
		alert('I`m sorry, there seems to be a problem with the import function.\n\nEither you entered invalid data or there is a problem with the program.\n\nIf the latter, you will have to enter the values into the various fields manually until this is fixed.');
	}
}


//CREATES LINK TEXT THAT CAN BE POSTED TO SHOW PICTURE AS LAYED OUT.
function getPicture(id){
	var t='http://scriptasylum.com/rc_speed/picture.html?';
	var tSrc;
	var iA=document.getElementById(id).getElementsByTagName('img');
	for(i=0;i<iA.length;i++){
		tSrc=iA[i].src.lastIndexOf("/")+1;
		tSrc=iA[i].src.substr(tSrc,iA[i].src.length);
		t+=tSrc+"~"+parseInt(iA[i].style.zIndex);
		if(i!=iA.length-1)t+="%20";
	}
	helpArray[202]=["Picture Link","Copy and paste the URL below <i>as a link</i> into your forum post to see the exact picture as shown: <br /><br /><form name=\"rcf\"><a href=\"javascript:document.forms['rcf'].picview.focus();document.forms['rcf'].picview.select();\">Select all...</a><br><textarea name=\"picview\" rows=3 cols=55 readonly style=\"font-size:11px; color:blue; background-color:lightgrey\">"+t+"</textarea></form>"];
	help(202);
}


/************************************************************************
HELP SYSTEM CODE
************************************************************************/

//NOTE: CERTAIN POSITIONS IN THE HELP ARRAY ARE RESERVED:
// 144=PINION TABLE FUNCTION
// 200=EXPORT FUNCTION
// 201=IMPORT FUNCTION
// 202=GET PICTURE FUNCTION
// OTHER RESERVED VALUES AS SHOWN BELOW

var helpArray=new Array();
helpArray[203]=["Battery Voltages","<center><table cellpadding='3' cellspacing='0' border='1' bordercolor='#000000'><tr align='center' nowrap='nowrap'><td><b>Battery Type</b></td><td width='80'><b>Minimum V</b></td><td width='80'><b>Nominal V</b></td><td width='80'><b>Maximum V</b></td></tr><tr align='right'><td align='left'>NiMH/NiCD</td><td>0.9v-1.0v</td><td>1.2v</td><td>approx 1.4v</td></tr><tr align='right'><td align='left'>Li-Po</td><td><b></b> 3.0v-3.2v</td><td>3.7v</td><td>4.2v</td></tr><tr align='right'><td align='left'>Li-Ion (A123 M1)</td><td><b></b> 2.0v-2.3v</td><td>3.3v</td><td>3.6v</td></tr><tr align='right'><td align='left'>Li-Ion (e-moli)</td><td><b></b> 3.0v</td><td>3.7v</td><td>4.2v</td></tr></table></center><br /><table cellpadding='3' cellspacing='0' border='0'><tr valign='top'><td width='45'>Min V</td><td>The minimum voltage these cells should be discharged to.</td></tr><tr valign='top'><td>Nom V</td><td>The nominal voltage rating per cell.</td></tr><tr valign=top><td>Max V</td><td>The voltage of the cell right off the battery charger.</td></tr><tr valign='top'><td><b></b></td><td>A good rule of thumb is to set the cutoff such that the cell voltage will &quot;rebound&quot; back up to the nominal value once the load is disconnected from the battery for approximately 20 minutes.</td></tr></table>"];
helpArray[204]=["Front/Rear Differential Ratio","This is the ratio from dividing the differential ring gear by the differential pinion gear. The result should be a number larger than 1.<br /><br />If your vehicle's differential is part of the transmission, enter 1 here.<br /><br />Open the dropdown list to select some popular preset values. This will automatically fill in the correct value for that differential. "];
helpArray[205]=["Transmission Gear Ratio","This is the <b>final</b> ratio of the whole transmission from input shaft to output shaft, which includes all the internal gears. The result should be a number larger than 1.<br /><br />If your vehicle does not use a transmission, enter 1 here. If your vehicle uses a center differential, this ratio will be part of the spur/pinion ratio and you should enter 1 here.<br /><br />Open the dropdown list to select some popular preset values. This will automatically fill in the correct value for that transmission."];
helpArray[206]=["Spur Gear Tooth Count","Enter the tooth count of the spur gear here. The spur gear is the large gear which meshes with the pinion gear (which is directly on the motor shaft). This gear almost always has more teeth than the pinion gear."];
helpArray[207]=["Pinion Gear Tooth Count","Enter the tooth count of the pinion gear here. This is the gear that is directly on the motor shaft."];
helpArray[208]=["Total Battery Voltage","Enter the total battery voltage your setup uses here. You can either enter the voltage directly into the box, or select the number of cells from the first dropdown list, and then the voltage of each cell in the second dropdown list. The combination of these lists will automatically enter the total voltage into the box.<br /><br />Hint: You can get the worst-case and best-case speed range of your setup by first using the lowest cell voltage for your specific battery type, and then the highest cell voltage for your specific battery type. Once you calculate the top speed using these two values, you will know how fast you will go with fresh batteries, and then when they are almost dead.<br /><br />For more information about the voltages for the various battery types, click <span class='help' onmousedown='help(203)'>here</span>"];
helpArray[209]=["Motor KV","This is the motor speed constant, which is how many RPMs (revolutions per minute) the motor will turn for each volt of battery power applied to it.<br /><br />A motor with a higher KV value has less turns, will spin faster, have less torque, draws more battery current, and has reduced rutime than a similarly sized motor with a lower KV value.<br /><br />Open the dropdown list to select from many popular motor choices by model. This will automatically fill in the motor value(s). The KV value is also listed in the drop-down."];
helpArray[210]=["Tire Diameter","Enter the total tire diameter in inches, which includes the rim AND tire.<br /><br />Example: The total diameter of a 2.2&quot; wheel, which includes the rim and tire, is approximately 3.75&quot; (depending on tires being used)."];
helpArray[211]=["Tire Ballooning","Enter the <u>added</u> radius, in inches, resulting from the tire spinning at high velocity. At high speeds, the centrifugal force causes the tire to expand. This increase in total diameter can drastically change the top speed of your vehicle.<br /><br />While neat to watch, tire ballooning reduces the amount of tire surface-area contacting the driving surface and may reduce traction. Ballooning can also cause the tire rubber to rip or break the glue bond which secures the tires to the rims.<br /><br /><center><img src=\"images\/ballooning.gif\" border=1></center><br />Click <a href='javascript:help(215)'>here</a> to see an animation of tire ballooning."];
helpArray[212]=["Additional Ratio","This is used when there is another gear ratio not included in the differential, spur/pinion, or normal transmission ratios.<br /><br />If this value is unknown or not applicable, leave this entry at 1."];
helpArray[213]=["1:1 Rollout Rule","The &quot;1:1 rollout rule&quot; is a method used by some to find the &quot;ideal&quot; gearing such that one revolution of the motor causes the tires to move one inch.<br /><br />Simply put, a 1:1 ratio means the total gear reduction equals the tire circumference. So, if you have 4&quot; tires (circumference = 12.57&quot;), the total reduction ratio of the differentials, transmission, etc should total 12.57.<br /><br />This rule does <b>not</b> suggest the gearing to achieve maximum top speed, nor does it guarantee a cool running setup. It is simply a starting point. You should always use ESC, motor, and battery temperatures as a guide. "];
helpArray[214]=["Rollout","Rollout is the ratio of how many revolutions of the motor causes the tires to move one inch.<br /><br />If the ratio is 0.5:1, then 1 motor revolution rotates the tire 0.5 inch.<br />If the ratio is 3:1, then 1 motor revolution rotates the tire 3 inches.<br /><br />Some people prefer a rollout of 1:1, which you can read about <span class='help' onmousedown='help(213)'>here</span>"];
helpArray[215]=["Tire Ballooning Animation","Animation courtesy of Rene (forum member &quot;Serum&quot;).<br><br><center><img src=\"images\/ani_ballooning.gif\" width=\"142\" height=\"200\" /></center>"];


var helpOpened=-1;
var helpDrag=false;
var helpXO=0;
var helpYO=0;


function help(n){
	var hw=document.getElementById('helpWindow');
	var hs=document.getElementById('helpShadow');
	var ea=document.getElementsByTagName('select');
	for(i=0;i<ea.length;i++)ea[i].style.visibility="hidden";
	var w_x=getWinWidth();
	var s_y=getScrollTop();
	hw.style.top=s_y+60+"px";
	hw.style.left=(w_x-450)/2+"px";
	document.getElementById('helpTitle').innerHTML=helpArray[n][0];
	document.getElementById('helpContent').innerHTML=helpArray[n][1];
	hw.style.visibility="visible";
	hs.style.width=getW(hw.id)+"px";
	hs.style.height=getH(hw.id)+"px";
	hs.style.left=parseInt(hw.style.left)+15+"px";
	hs.style.top=parseInt(hw.style.top)+15+"px";
	hs.style.visibility="visible";
	helpOpened=n;
}


function closeHelp(){
	var hw=document.getElementById('helpWindow');
	var hs=document.getElementById('helpShadow');
	hw.style.visibility="hidden";
	hs.style.visibility="hidden";
	var ea=document.getElementsByTagName('select');
	for(i=0;i<ea.length;i++)ea[i].style.visibility="visible";
	helpOpened=-1;
}


document.write('<div id="helpWindow" style="z-index:100000"><div id="helpTitle" onmouseup="helpDrag=false;">Help System</div><div id="helpContent"></div><div id="helpClose" onmouseup="closeHelp()"></div></div><div id="helpShadow" style="z-index:90000"></div>');


document.getElementById('helpTitle').onmousedown=helpDragInit;


//SETS DOCUMENT MOUSE UP/MOVE EVENT HANDLERS (ONLY ONCE)
if(document.addEventListener){ //W3C
	document.addEventListener('mousemove',helpTrackMouse,false);
}else if(document.attachEvent){ //<IE9
	document.attachEvent('onmousemove',helpTrackMouse);
}//IF NOT W3C OR <IE9 THEN DONT ALLOW DRAGGING...


//IF DRAGGING IS ACTIVE
function helpTrackMouse(e){
	if(helpDrag){
		var hw=document.getElementById('helpWindow');
		var hs=document.getElementById('helpShadow');
		var x=(document.all)?event.clientX+document.body.scrollLeft:e.pageX;
		var y=(document.all)?event.clientY+document.body.scrollTop:e.pageY;
		hw.style.left=(x-helpXO)+"px";
		hw.style.top=(y-helpYO)+'px';
		hs.style.left=(x-helpXO)+15+"px";
		hs.style.top=(y-helpYO)+15+"px";		
	}
	return false;
}


//GET INITIAL MOUSE OFFSETS
function helpDragInit(e){
	if(!helpDrag){
		helpXO=((document.all)?event.clientX+document.body.scrollLeft:e.pageX)-getX('helpWindow');
		helpYO=((document.all)?event.clientY+document.body.scrollTop:e.pageY)-getY('helpWindow');;
		helpDrag=true;
		return false;
	}
}


/************************************************************************
NAVIGATION MENU CODE
************************************************************************/


var tid=0;
var currid=null;


//HIDES 'hidden' OR SHOWS 'visible' SELECT ELEMENTS ON A PAGE.
function hideShowSelects(action){
		var els=document.getElementsByTagName('select');
		for(var i=0;i<els.length;i++)els[i].style.visibility=action;
}


//HIDES THE SUBMENU ELEMENT
function hideDropDown(el){
	var el=document.getElementById(el);
	if(el.isMenu)document.getElementById('_dropDownContent').style.display="none";
	hideShowSelects('visible');
	el.className=el.normal;
}


//ADDS SMALL DELAY SO THE SUBMENU WON'T DISAPPEAR WHEN THE USER MOUSE GOES FROM THE MAIN MENU TO SUB MENU
function startDelay(id){
	tid=setTimeout('hideDropDown("'+id+'")',40);
}


//FUNCTION TO SET UP SUBMENUS
function createMenu(HV, id, mhClass, mhHClass, mClass, iClass, iHClass, menu){
	if(document.getElementById && document.getElementsByTagName){
		var t='';
		if(menu!=[]){
			for(var m=0;m<menu.length;m++){
				t+='<div class="'+iClass+'" ';
				t+='onmouseup="document.location.href=\''+menu[m][1]+'\'" ';
				t+='onmouseover="this.className=\''+iHClass+'\'; clearTimeout(tid)" ';
				t+='onmouseout="this.className=\''+iClass+'\'; startDelay(\''+id+'\')" ';
				t+='>'+menu[m][0]+'</div>';
			}
		}
		mel=document.getElementById(id);
		mel.isMenu=(menu==false)?false:true;
		mel.mClass=mClass;
		mel.normal=mhClass;
		mel.hover=mhHClass;
		mel.getX=function(){
			var l=0;
			var el=this;
			if(el.offsetParent){
				while(el){
					l+=el.offsetLeft;
					el=el.offsetParent;
				}
			}else if(el.x)l+=el.x;
			return l;
		}
		mel.getY=function getY(){
			var t=0;
			var el=this;
			if(el.offsetParent){
				while(el){
				t+=el.offsetTop;
				el=el.offsetParent;
				}
			}else if(el.y)t+=el.y;
			return t;
		}
		mel.getH=function(){
			var el=this;
			var h=0;
			if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))h=el.style.pixelHeight;
			else h=el.offsetHeight;
			return h;
		}
		mel.getW=function(){
			var el=this;
			var w=0;
			if((navigator.userAgent.indexOf("Opera 5")!=-1)||(navigator.userAgent.indexOf("Opera/5")!=-1))w=el.style.pixelWidth;
			else w=el.offsetWidth;
			return w;
		}
		mel.onmouseover=function(){
			if(currid!=this.id && currid!=null){
				var tel=document.getElementById(currid);
				tel.className=tel.normal;
			}
			currid=this.id;
			this.className=this.hover;
			clearTimeout(tid);
			var el=document.getElementById('_dropDownContent');
			if(HV=="V"){
				el.style.left=this.getX()+this.getW()-3+'px';
				el.style.top=this.getY()+0+"px";
			}else{
				el.style.left=this.getX()+'px';
				el.style.top=this.getY()+this.getH()+1+"px";
			}
			if(this.isMenu)hideShowSelects('hidden');
			else hideShowSelects('visible');
			el.className=this.mClass;
			el.innerHTML=this.txt;
			el.style.display=(this.isMenu)?"block":"none";
		}
		mel.onmouseout=function(){
			if(!this.isMenu)this.className=this.normal;
			if(this.isMenu)tid=setTimeout('hideDropDown("'+this.id+'")',40);
		}
		mel.txt=t;
	}
}


//DROPDOWN MENU CONTAINER
document.write('<div id="_dropDownContent" style="display:none; position:absolute; z-index:999999999"></div>');


//FUNCTION TO WRITE OUT THE MENU
function writeMenu(HV){
	var t='<div id="navM_'+HV+'" style="top:0px;">';
	if(HV=="H")t+='&nbsp;';
	for(i=0;i<headerlist.length;i++){
		if(headerlist[i][2]=='')t+='<span id="mh'+headerlist[i][0]+'" class="navEl_'+HV+'" >'+headerlist[i][1]+'</span>';
		else if(headerlist[i][2]=='*')t+=headerlist[i][1];
		else t+='<span id="mh'+headerlist[i][0]+'" class="navEl_'+HV+'" onmouseup="document.location.href=\''+headerlist[i][2]+'\'">'+headerlist[i][1]+'</span>';
	}
	if(HV=="V")t+='<div style="height:250px; width:1px;"><br /></div>';
	t+='</div>';
	document.write(t);
	var ta;
	for(var h=0;h<headerlist.length;h++){
		ta=new Array();
		for(var m=0;m<linklist.length;m++){
			if(headerlist[h][0]==linklist[m][0])ta[ta.length]=[linklist[m][1],linklist[m][2]];
		}
		if(headerlist[h][2]!='*')createMenu( HV, "mh"+h, "navEl_"+HV, "navElH_"+HV, "navMenuBox", "DDNormal", "DDHover", ta);
	}
}


//FUNCTION TO POSITION NAVIGATION MENU AS USER SCROLLS
function posNavM(){
	var navEl=document.getElementById('navM_V');
	if(!navEl)navEl=document.getElementById('navM_H');
	var y=parseInt(navEl.style.top);
	var sy=getScrollTop();
	window.status=y;
	navEl.style.top=((sy-y)/3)+y+'px';
}


//POSITIONS MENU ON PAGE SCROLL. ONLY FOR VERTICAL MENU
//setInterval('posNavM()',100)


/************************************************************************
WEBSITE FOOTER
************************************************************************/

function writeFooter(){
	var t='';
	t+='<div id="footer">';
	t+=' 1998-'+new Date().getFullYear();
	t+='<br /><br /><br /><br /><a href="tiresize.html"><div style="width:30px; height:30px;"></div></a>';
	t+='</div>';
	document.write(t);
}

writeFooter();




